define([
    'Vent',
    'modules/page/popup/warning-popup-view',
    'text!modules/connection/server-error.html',
],
function (vent, WarningPopupView, template) {
    'use strict';

    return WarningPopupView.extend({
        id: 'server-error',
        className: 'server-error',
        template: template,
        templateContext: function () {
            return {
                messageType: this.model ? this.model.get('messageType') : 0,
                errorMessage: this.model ? this.model.get('errorMessage') : '',
                errorType: this.model ? this.model.get('errorType') : 'Error',
            };
        },
        events: {
            'popupafteropen': 'focusOnHeader',
            'popupafterclose': 'destroy',
            'click .warning-continue-btn': 'retry',
            'click button': 'closePopup',
        },
        retry: function() {
            var jqxhr;
            var settings;
            var dfd;

            if (this.model) {
                jqxhr = this.model.get('jqxhr');
                settings = this.model.get('settings');

                if (jqxhr && jqxhr.dfd) {
                    dfd = jqxhr.dfd;
                    dfd.promise(jqxhr);
                    if (settings) {
                        $.ajax(settings).done(dfd.resolve);
                    }
                } else if (settings) {
                    $.ajax(settings);
                }
            }
        },
    });
});
